/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.TimeValueProperties;
import java.io.IOException;

public class FrequencyParameter
extends ProtectionParameter {
    static final long serialVersionUID = 0L;
    private int frequencyParameterSerializedDataVersion = 1;
    protected Timer fTimeInterval = new Timer();
    protected int fOnThreshold;
    protected int fOffThreshold;
    protected boolean fState;
    protected int fMin = 0;
    protected int fMax = 9999;

    public FrequencyParameter() {
    }

    public FrequencyParameter(Block block) {
        super(block);
    }

    public IntValueProperties getOffThreshold() {
        return new IntValueProperties(this.fMin, this.fMax, 1, this.fOffThreshold, "error.dialog.invalidValue", "Invalid Value");
    }

    public IntValueProperties getOnThreshold() {
        return new IntValueProperties(this.fMin, this.fMax, 1, this.fOnThreshold, "error.dialog.invalidValue", "Invalid Value");
    }

    public void setOnThreshold(IntValueProperties onTreshold) {
        this.setOnThreshold(onTreshold.getCurrentValue());
    }

    public Timer getTimeInterval() {
        return this.fTimeInterval;
    }

    public TimeValueProperties getIntervalTimerParamTime() {
        return this.getTimeInterval().getParamTimeProperties();
    }

    public void setIntervalTimerParamTime(TimeValueProperties newTime) {
        newTime.setParameter(this);
        this.getTimeInterval().setParamTimeProperties(newTime);
    }

    public TimeUnit getParamInterval() {
        return this.getTimeInterval().getParamTime();
    }

    public void setParamInterval(TimeUnit intervall) {
        this.getTimeInterval().setParamTime(intervall);
    }

    public TimeUnit getPassedInterval() {
        return this.getTimeInterval().getPassedTime();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fTimeInterval = (Timer)dr.readStorable();
        this.fOnThreshold = dr.readInt();
        this.fOffThreshold = dr.readInt();
        this.fMin = dr.readInt();
        this.fMax = dr.readInt();
        this.fState = dr.readBoolean();
    }

    public void setOffThreshold(int offThreshold) {
        this.fOffThreshold = offThreshold;
    }

    public void setOffThreshold(IntValueProperties offThreshold) {
        this.setOffThreshold(offThreshold.getCurrentValue());
    }

    public void setOnThreshold(int onThreshold) {
        this.fOnThreshold = onThreshold;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fTimeInterval);
        dw.writeInt(this.fOnThreshold);
        dw.writeInt(this.fOffThreshold);
        dw.writeInt(this.fMin);
        dw.writeInt(this.fMax);
        dw.writeBoolean(this.fState);
    }

    public void setTimeInterval(Timer newTimeInterval) {
        this.fTimeInterval = newTimeInterval;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware hardware = (Hardware)hardwareChangedEvent.getNewValue();
        TimeUnit[] availableTimeUnits = (TimeUnit[])hardware.getProperty("availableTimeUnits");
        this.getTimeInterval().convertTimerTo(availableTimeUnits);
    }
}

